﻿//////////////////////////////////////////////
// Effect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Shader ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

#include "EffectType.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT Effect
	{
		public :

			// Constructor, destructor
			Effect (EFFECT_TYPE type) noexcept ;
			virtual ~Effect () ;

			// Getters
			nkMemory::StringView getName () const ;
			nkGraphics::Shader* getShader () const ;
			EFFECT_TYPE getType () const ;

			// Setters
			void setName (nkMemory::StringView value) ;

			// Load
			virtual bool load () = 0 ;
			virtual void unload () = 0 ;

		protected :

			// Attributes
			// Name for identification
			nkMemory::String _name ;

			// Final shader that will be held by the material, populated by children class
			nkMemory::UniquePtr<nkGraphics::Shader> _shader ;

			// Effective underlying type
			EFFECT_TYPE _type ;
	} ;
}